<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyProfile extends Model
{
    protected $table = 'company_profiles';
    protected $primaryKey = 'Company_id';
    public $timestamps = true;

    protected $fillable = [
        'User_id',
        'Company_name',
        'Description',
        'family_details',
        'Logo_url',
        'Location',
        'Subscription_id',
        'first_name',
        'last_name',
        'postal_code',
        'type_of_care_needed',
        'availability_needs',
        'special_needs',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
        'Updated_at' => 'datetime',
        'family_details' => 'array',
        'type_of_care_needed' => 'array',
        'availability_needs' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }

    public function subscription()
    {
        return $this->belongsTo(Subscription::class, 'Subscription_id', 'Subscription_id');
    }
}
